<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class FieldItemLanguage extends Model 
{

    protected $table = 'lim_field_item_languages';
    public $timestamps = true;
    protected $fillable = array('lim_language_id', 'lim_field_item_id', 'name', 'description');
    protected $visible = array('lim_language_id', 'lim_field_item_id', 'name', 'description');

    public function language()
    {
        return $this->belongsTo('App\Models\Language', 'lim_language_id');
    }

    public function item()
    {
        return $this->belongsTo('App\Models\FieldItems', 'lim_field_item_id');
    }

}